document.addEventListener('DOMContentLoaded', () => {
    // Smooth scrolling for navigation links
    document.querySelectorAll('nav a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();

            const targetId = this.getAttribute('href');
            const targetElement = document.querySelector(targetId);
            const headerOffset = document.querySelector('#header').offsetHeight; // Get fixed header height

            // Calculate position to scroll to, accounting for fixed header
            const elementPosition = targetElement.getBoundingClientRect().top + window.pageYOffset;
            const offsetPosition = elementPosition - headerOffset - 20; // -20px for extra padding


            window.scrollTo({
                top: offsetPosition,
                behavior: 'smooth'
            });

            // Optional: Close mobile menu after clicking a link
            const navMenu = document.querySelector('.main-nav'); // Changed to .main-nav to toggle entire nav
            if (window.innerWidth <= 768 && navMenu.classList.contains('active')) { // Only for mobile
                navMenu.classList.remove('active');
            }
        });
    });

    // Mobile Menu Toggle
    const menuToggle = document.querySelector('.menu-toggle');
    const mainNav = document.querySelector('.main-nav'); // Targeting the main-nav container now

    if (menuToggle) {
        menuToggle.addEventListener('click', () => {
            mainNav.classList.toggle('active');
        });
    }

    // Active link highlighting on scroll
    const sections = document.querySelectorAll('section');
    const navLinks = document.querySelectorAll('.main-nav ul li a');
    const headerHeight = document.querySelector('#header').offsetHeight; // Get fixed header height

    const activateNavLink = () => {
        let currentActiveSectionId = '';

        sections.forEach(section => {
            // Adjust section top position by header height
            const sectionTop = section.offsetTop - headerHeight - 30; // Added extra buffer
            const sectionBottom = sectionTop + section.clientHeight;

            if (window.pageYOffset >= sectionTop && window.pageYOffset < sectionBottom) {
                currentActiveSectionId = section.getAttribute('id');
            }
        });

        navLinks.forEach(link => {
            link.classList.remove('active');
            if (link.getAttribute('href').includes(currentActiveSectionId)) {
                link.classList.add('active');
            }
        });
    };

    // Run on scroll and on load
    window.addEventListener('scroll', activateNavLink);
    window.addEventListener('load', activateNavLink); // To set active link on initial load
});